-- Here is all global functions, enums, and modules defined

-- ENUM    --making up enums
--GameStates
GS_PLAY = 0
GS_MENU = 1
GS_FREEZE = 2
GS_EXIT = 3
GS_DIALOG = 4
--resources
RC_TEXTURE = 0
RC_FONT = 1
--FilterMode (texture)
FM_NEAREST = 0
FM_LINEAR = 1
--WrapMode (texture)
WM_CLAMP = 0
WM_REPEAT = 1
--ApplyMode (texture)
AM_MODULATE = 0
AM_DECAL = 1
--AnimationMode (animation)
MODE_LOOP = 0
MODE_ONCE = 1
MODE_PINGPONG = 2
--AnimationDirection (animation)
DIRECTION_FORWARD = 0
DIRECTION_REVERSE = 1
--BlendMode (BlendMode)
BM_DEFAULT = 0
BM_ADDITIVE = 1
--SpriteType
ST_TEXTURED = 0
ST_ANIMATED = 1
ST_PARTICLE= 2
ST_EMITTER = 3
ST_SCROLLING = 4
ST_ANIMATED_PARTICLE = 5
--OcjectCommand
OC_UP = 0
OC_DOWN = 1
OC_LEFT = 2
OC_RIGHT = 3
OC_USE = 4
--ScrollingSprite
SS_NONE = 0
SS_HORIZONTAL = 1
SS_VERTICAL = 2
--ControllableType
CT_CURSOR = 0
CT_PLAYER = 1
--CreaturePlayerType
CPT_PLAYER = 0
CPT_STANDING_CREATURE = 1
CPT_MOVING_CREATURE = 2
--PolygonShapeConstuctorType
PSC_TRIANGLE = 0
PSC_POLYGON = 1
PSC_POLYGON_RAD = 2
PSC_RECTANGLE = 3
--TriggerType
TT_GATE = 0
TT_USE = 1
TT_TIMER = 2
--PlayerState
PS_DEAD = 0
--Direction
LEFT=0
RIGHT=1
UP=2
DOWN=3
--DialogType
QUESTION=1
LINE=0
--HorizontalMode
H_CENTER = 0
H_LEFT = 1
H_RIGHT = 2
--VerticalMode
V_TOP = 2
V_BOTTOM = 1
V_CENTER = 0

--FUNCTIONS

-- takes in the name of the texture, the cols and rows in the grid, the starting and ending frame in usage.
function lua_init_subtextures(name,cols, rows, startf, endf)     --Works only with squares (suorakulmiot)
    local i = startf
    local xpos = startf
    local sum = cols*rows       --sums the place in the picture
    local min_x = 0
    local min_y = 0
    local max_x = 0
    local max_y = 1
    local row_atm = 1
    
    -- couple extra checks for cases where startf ~= 1
    if startf ~= 1 then
        while i > cols*row_atm do
            row_atm = row_atm +1
        end
        xpos = i - cols*(row_atm-1)
    end
    
    min_y = (1/rows)*(rows-row_atm)
    
    while i <= endf do
        --chekcs if the i is greater than the rows
        if i > cols*row_atm then 
            row_atm = row_atm+1 
            max_y = min_y
            min_y = (1/rows)*(rows-row_atm)
            max_x = 0
            xpos = 1
        end
        
        min_x = max_x
        max_x = (1/cols)*xpos
        local subname = name .. "_" .. tostring(i)
        lua:init_subtexture(name,subname, min_x, min_y, max_x, max_y)
        i = i+1
        xpos = xpos + 1
    end
end

-- this inits the animations from a rectangle texture and turns them into a animation
function lua_init_subtexture_animation(name,cols, rows, startf, endf, mode, direction,delay)
    lua_init_subtextures(name,cols, rows, startf, endf)
    lua:init_animation(name,mode, direction)
    local sum = endf-startf
    local i = 1
    
    while i<= sum do        
        local subname = name .. "_" .. tostring(i)
        lua:animation_add_frame(name, subname , delay)
        i = i+1
    end
    a = i
end

-- this takes all the images whom are named 0001.png, 0010.png, 0121.png, from a directory path and makes them into a animation
function lua_init_texture_animation(name, path, frames, mode, direction,delay,filterMode, wrapModeX, wrapModeY, applyMode)
    lua:init_animation(name,mode,direction)
    
    --load the textures.
    local i = 1
    
    while i< frames do
        local num = tostring(i)
        -- creates the name with right amount of zeros
        while string.len(num) < 4 do
            local tmp = "0" .. num
            num = tmp
        end
        local subname = name .. num
        num = num .. ".png"
        local subpath = path .. num
        
        --load texture        
        lua_init_texture(subname, subpath,filterMode,wrapModeX,wrapModeY,applyMode)
        --convert into subtexture
        lua:init_subtexture(subname,subname, 0.0, 0.0, 1.0, 1.0)
        --add as frame
        lua:animation_add_frame(name,subname, delay)
        
        i = i+1
    end
end

function lua_init_texture(name, path, filterMode, wrapModeX, wrapModeY, applyMode)
    lua:init_texture(name, path, filterMode, wrapModeX,wrapModeY,applyMode) --load resource into collection
    lua:load_resource(RC_TEXTURE, name)     --load resource into renderer
end

function lua_init_font(name, style, size, bold, italic)
    lua:init_font(name, style, size, bold, italic)
    lua:load_resource(RC_TEXTURE,name)
end

function timer(time, script)
    lua:create_trigger("timed", TT_TIMER, script,"", 0, 0) --name, type, on_time_script, nothing,none,none
    lua:timed_trigger_repeat("timed",time, false) -- name, delay, repeat
    lua:trigger_upload("timed",0) --name
end

function timer_adv(time, script,is_repeating,parent_id)
    lua:create_trigger("timed", TT_TIMER, script,"", 0, 0) --name, type, on_time_script, nothing,none,none
    lua:timed_trigger_repeat("timed",time, is_repeating) -- name, delay, repeat
    lua:trigger_upload("timed",parent_id) --name
end

--converts the desired time in seconds into remo speed
function time_to_remo_speed(time) --time to be converted
    return (1.0/time)
end

function vector_distance(x1,y1,x2,y2) -- 1-2
    local x = x1-x2
    local y = y1-y2
    local length = x*x+y*y
    length = math.sqrt(length)
    return length
end

has_printed_counter = 0
function print(value) --value to print
    local str = tostring(value)
    lua:create_text("print","comic_sans",lua:get_camera_x(),lua:get_camera_y()-(30.0*has_printed_counter),0,0.75)
    lua:text_color("print",1.0,1.0,1.0,1.0)
    lua:add_text("print", str)
    lua:convert_to_hud("print")
    g_level.upload("print",lua:get_num_layers()-1)
    lua:gameobject_remove_from_temp_list( "print" )

    has_printed_counter = has_printed_counter + 1
end

function print_adv(value,time) --value to print,time to show
    local str = tostring(value)
    lua:create_text("print","comic_sans",lua:get_camera_x(),lua:get_camera_y()-(30.0*has_printed_counter),0,0.75)
    lua:text_color("print",1.0,1.0,1.0,1.0)
    lua:add_text("print", str)
    lua:remorfable_sprite("remo", "print", time_to_remo_speed(time), false)             -- name, sprite_name, speed, repeat
    lua:add_key_frame(0.99, 0.0, 0.0, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("remo")
    g_level.upload("remo",lua:get_num_layers()-1)
    lua:gameobject_remove_from_temp_list( "print" )
    
    has_printed_counter = has_printed_counter + 1
end

--fades to black
function fade_out(time)
    local scale = 1000
    lua_init_texture("super_generic_effect_name", "data/images/effects/black.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua:create_sprite("super_generic_effect_name", ST_TEXTURED,"super_generic_effect_name",      lua:get_camera_x(), lua:get_camera_y()) 
    lua:sprite_shape("super_generic_effect_name",ST_TEXTURED,                          scale * 16.0, scale * 16.0)
    lua:textured_sprite_tex_coords("super_generic_effect_name", ST_TEXTURED,           1.0, 1.0, 1.0, 1.0)
    lua:sprite_color("super_generic_effect_name",                                       1.0,1.0,1.0,0.0)
    lua:remorfable_sprite("super_generic_remorfable_name", "super_generic_effect_name", time_to_remo_speed(time), false) -- name, sprite_name, speed, repeat
    --lua:add_key_frame(1.0, lua:get_camera_x(), lua:get_camera_y(), 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame(1.0, 0.0, 0.0,0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
    lua:upload_key_frame("super_generic_remorfable_name")
    g_level.upload("super_generic_remorfable_name",lua:get_num_layers()-1)   --number of layers is 5, thus the index of the upperst layer is 4
end

--fades from black
function fade_in(time)
    local scale = 1000
    lua_init_texture("super_generic_effect_name", "data/images/effects/black.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
    lua:create_sprite("super_generic_effect_name1", ST_TEXTURED,"super_generic_effect_name",      lua:get_camera_x(), lua:get_camera_y()) 
    lua:sprite_shape("super_generic_effect_name1",ST_TEXTURED,                          scale * 16.0, scale * 16.0)
    lua:textured_sprite_tex_coords("super_generic_effect_name1", ST_TEXTURED,           1.0, 1.0, 1.0, 1.0)
    lua:sprite_color("super_generic_effect_name1",                                       1.0,1.0,1.0,1.0)
    lua:remorfable_sprite("super_generic_remorfable_name", "super_generic_effect_name1", time_to_remo_speed(time), false) -- name, sprite_name, speed, repeat
    --lua:add_key_frame(1.0, lua:get_camera_x(), lua:get_camera_y(), 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame(1.0, 0.0, 0.0, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
    lua:upload_key_frame("super_generic_remorfable_name")
    g_level.upload("super_generic_remorfable_name",lua:get_num_layers()-1)   --number of layers is 5, thus the index of the upperst layer is 4
end

function stopper(direction,place) --(RIGHT/LEFT/UP/DOWN)(float in the axel)
    local width = 0.0
    local height = 0.0
    local x = 0.0
    local y = 0.0
    if direction == LEFT or direction == RIGHT then
        width = 40.0
        height = 100000.0
        if direction == LEFT then
            x = place - (width/2)
        else --right
            x = place + (width/2)
        end
    elseif direction == UP or direction == DOWN then    
        width = 40.0
        height = 100000
        if direction == UP then
            y = place + (width/2)
        else --right
            y = place - (width/2)
        end
    else
        error("bad value")
    end
    
    lua:create_shape("generic_name_vol1",PSC_RECTANGLE,width,height) -- name, type, width, height
    lua:create_collider(1111,"generic_name_vol1",x,y) --id, shape, x ,y
end

function switch(script,x,y) --scriptname, x, y
    local radius = 100.0
    lua:create_circle( "generic_shape_name_vol1213", 0.0,0.0, radius)                         --name, x, y, radius
    lua:create_trigger("generic_trigger_name_vol12414", TT_USE, script,"",x,y) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("generic_trigger_name_vol12414", TT_USE, "generic_shape_name_vol1213") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("generic_trigger_name_vol12414", TT_USE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("generic_trigger_name_vol12414", TT_USE, "player") --name, type, group_name
    lua:trigger_upload("generic_trigger_name_vol12414",0) --name
end 

function switch_adv(script,x,y,radius,id) --scriptname, x, y, radius, id
    lua:create_circle( "generic_shape_name_vol1213", 0.0,0.0, radius)                         --name, x, y, radius
    lua:create_trigger("generic_trigger_name_vol12414", TT_USE, script,"",x,y) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("generic_trigger_name_vol12414", TT_USE, "generic_shape_name_vol1213") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("generic_trigger_name_vol12414", TT_USE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("generic_trigger_name_vol12414", TT_USE, "player") --name, type, group_name
    lua:trigger_upload("generic_trigger_name_vol12414",id) --name
end 

function trigger(script_in,script_out,width,height,x,y) --scriptname in, scriptname out, width,height,x,y
    lua:create_shape("uberduber_generic_shapename",PSC_RECTANGLE,width,height) -- name, type, width, height
    lua:create_trigger("uberduber_generic_trigger", TT_GATE, script_in,script_out,x,y) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("uberduber_generic_trigger", TT_GATE, "uberduber_generic_shapename") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("uberduber_generic_trigger", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("uberduber_generic_trigger", TT_GATE, "player") --name, type, group_name
    lua:trigger_upload("uberduber_generic_trigger",0) --name
end

function highlight(x,y,offset,radius,layer) --x,y,offset in vertical axis, radius, layer
    require 'g_highlights'
    g_highlights.add(x,y,offset,radius,layer)
end